using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Input.Touch;
using Microsoft.Xna.Framework.Media;

namespace PanicButton
{
    /// <summary>
    /// To jest gwny typ dla naszej gry
    /// </summary>
    public class PanicButtonGame : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // Dane gry

        int displayWidth;
        int displayHeight;

        Texture2D buttonTexture;
        Rectangle buttonRectangle;
        SoundEffect panicSound;

        public PanicButtonGame()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.SupportedOrientations =
                DisplayOrientation.Default |
                DisplayOrientation.LandscapeLeft |
                DisplayOrientation.LandscapeRight |
                DisplayOrientation.Portrait;

            Window.OrientationChanged += new EventHandler<EventArgs>(Window_OrientationChanged);

            // Domylna czstotliwo odwieania dla Windows Phone wynosi 30 fps.
            TargetElapsedTime = TimeSpan.FromTicks(333333);
        }

        void Window_OrientationChanged(object sender, EventArgs e)
        {
            positionButton();
        }

        private void positionButton()
        {
            displayWidth = GraphicsDevice.Viewport.Width;
            displayHeight = GraphicsDevice.Viewport.Height;

            if (displayWidth > displayHeight)
            {
                // tryb poziomy
                buttonRectangle = new Rectangle(
                    (displayWidth - displayHeight) / 2, 0,
                    displayHeight, displayHeight);
            }
            else
            {
                // tryb pionowy
                buttonRectangle = new Rectangle(
                    0, (displayHeight - displayWidth) / 2,
                    displayWidth, displayWidth);
            }

        }

        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            base.Initialize();
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            buttonTexture = Content.Load<Texture2D>("PanicButton");
            panicSound = Content.Load<SoundEffect>("PanicSound");

            positionButton();

        }

        /// <summary>
        /// UnloadContent bedzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        /// <summary>
        /// Pozwala uruchomi w grze logik, tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            // Pozwala opusci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            TouchCollection touches = TouchPanel.GetState();

            if (touches.Count() > 0)
            {
                TouchLocation touch = touches[0];
                if (touch.State == TouchLocationState.Pressed)
                {
                    if (buttonRectangle.Contains((int)touch.Position.X, (int)touch.Position.Y))
                    {
                        panicSound.Play();
                    }
                }
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();

            spriteBatch.Draw(buttonTexture, buttonRectangle, Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
